/*****************************************************
This program was produced by the
CodeWizardAVR V2.04.4a Advanced
Automatic Program Generator
 Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project :
Version :
Date    : 2010/10/19
Author  : Mohammad Mazarei
Company : M2Prog
Comments:


Chip type               : ATmega32
Program type            : Application
AVR Core Clock frequency: 8.000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 512
*****************************************************/

#include <mega32.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#include <delay.h>
#include <ks0108.h>.
#include <stdio.h>
#include "GFX/bitmap.c"
//

flash char tetris_logo[]=
{
80,7,

0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0xC1,0x41,0x41,0x41,0x41,0x21,0x21,0x21,0x11,0x11,0x11,0x11,0x31,0x21,0x21,0x21,0x41,0x41,0x41,0x41,0xC1,0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x00,0x10,0x00,0x7C,0x7C,0x7E,0x7F,0x78,0xF8,0xF8,0xF8,0xF8,0x00,0x00,0x40,0x40,0xE0,0xD0,0x30,0xF0,0x10,0x30,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x02,0x06,0x04,0x18,0x30,0x60,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x20,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x00,0x3A,0x45,0xAA,0x95,0x55,0x3F,0x01,0x00,0x80,0x41,0x7F,0xC0,0xF0,0xF0,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x4F,0x7C,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x53,0x3A,0xBC,0x9C,0x5C,0x70,0xC0,0x80,0x00,0x00,0x00,0x00,0x80,0xC0,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x80,0xC0,0x60,0x18,0x06,0x07,0x1F,0x40,0x80,0x00,0x01,0x07,0x0F,0x3F,0x60,0xC0,0x80,0x00,0x00,0x00,0x80,0xC0,0x70,0x48,0x66,0x65,0xA4,0x44,0x4D,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x19,0x0E,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0xC0,0xE0,0xF8,0xFC,0x03,0xFD,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFF,0x0C,0xF8,0xC0,0x00,0x00,0x06,0x0C,0x03,0x06,0x0E,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x3B,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x08,0x38,0x58,0x98,0x30,0x30,0x30,0x64,0x64,0x64,0x30,0x10,0x0C,0x03,0xFF,0xFF,0xFF,0xFF,0x00,0x7B,0x7B,0x7B,0x7B,0x7B,0xFB,0xFB,0xFB,0x00,0x7F,0x7F,0x7F,0x7C,0x18,0xF8,0xD0,0xC0,0xC0,0x40,0x40,0x20,0xB0,0x50,0x38,0x0C,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x04,0x04,0x08,0x10,0x1F,0x3F,0x3F,0x00,0x6F,0x6F,0x6F,0x6F,0xE0,0xFF,0xFF,0xFF,0xFF,0xE0,0xEF,0x6F,0x6F,0x0F,0x6F,0x6F,0x2F,0x2F,0x20,0x0F,0x1F,0x0F,0x0F,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

flash char agape_logo[]={
128,8,
0xFF,0xFF,0xFF,0xFF,0x0F,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF9,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0x38,0xDC,0xEC,0xE4,0x76,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0xEE,0xDC,0x3C,0xF8,0xF0,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x1F,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFE,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0x00,0xFF,0xFF,0x01,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x0C,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x9F,0xC7,0xF0,0xFF,0x3F,0x00,0xFF,0xFF,0x00,0x00,0xCF,0xCF,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x1C,0x00,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x0F,0x3F,0xF8,0xE7,0x9F,0xBE,0x70,0x60,0x60,0x60,0x60,0x60,0x60,0x7F,0x7F,0x7F,0x00,0xFF,0xFF,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x03,0x01,0x00,0x00,0x00,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0xC3,0xC3,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,0x40,0x20,0xA0,0x00,0xFF,0xFF,0x20,0x30,0x60,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF8,0x78,0x78,0x78,0x38,0x38,0x98,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xE0,0xF8,0xF8,0xF8,0xF8,0xF0,0xE0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0xE0,0xF0,0xF8,0xF8,0xF8,0x78,0x78,0x38,0x80,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xC0,0xF0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0x00,0x80,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xB8,0xB8,0x38,0x18,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x1F,0x1F,0x7F,0xFF,0xFF,0x71,0x6E,0xFE,0xFF,0xD7,0xD7,0xD7,0xD7,0xF6,0xFF,0xFE,0x6E,0x7F,0x3F,0x3F,0xBE,0x9E,0xD8,0xC0,0x00,0x00,0x00,0x00,0x1F,0x3F,0x7F,0x7F,0x7F,0x79,0x70,0x20,0x00,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x3F,0x0F,0x1F,0x7F,0x7F,0x7F,0x3F,0x1F,0x03,0x70,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x3C,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x00,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x77,0x77,0x33,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,
0x7F,0x7F,0xFF,0xFC,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFB,0xF2,0xFA,0xFB,0xFB,0xFD,0xFD,0xBD,0xBF,0xBE,0xBE,0x9E,0x9E,0x8F,0x8F,0x87,0x87,0x83,0x81,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF8,0xFF,0xFF

}  ;


flash char maze_logo[]=
{
80,7,
0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xE1,0x51,0xB1,0x51,0x01,0x01,0xA1,0x41,0x81,0x41,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x41,0xE1,0x51,0xA1,0x01,0x01,0x01,0xB9,0x55,0xF9,0x55,0xB9,0x55,0xA9,0x55,0xB9,0x55,0xA9,0xD5,0xA9,
0x55,0x0A,0x55,0x22,0x55,0xAA,0x55,0x2B,0x55,0xAF,0x55,0xBB,0x55,0x00,0x00,0xBB,0x55,0xAF,0x55,0xBB,0x55,0xAA,0x54,0x20,0x50,0x00,0x00,0xA0,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x20,0x54,0x8A,0x55,0x2B,0x55,0xAE,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0xAA,
0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x01,0x00,0x00,0xBB,0x55,0xAA,0x55,0x22,0x55,0x00,0x55,0x02,0x55,0x00,0x00,0xAA,0x55,0xAA,0x55,0x00,0x00,0xB0,0x50,0x20,0x50,0x80,0x50,0x20,0x50,0xA0,0x50,0x20,0x50,0xA0,0x50,0x00,0x00,0xAA,0x55,0xBB,0x00,0x00,0x55,0x02,0x55,0x00,0x55,0x22,0x55,0xAA,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0x00,0x55,0xAA,
0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x50,0x00,0x00,0xBB,0x55,0xAA,0x55,0xA2,0x55,0x80,0x55,0x22,0x55,0x00,0x00,0x6A,0x55,0x2A,0x55,0x00,0x00,0x6A,0x55,0x22,0x55,0x20,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0x2A,0x55,0x00,0x00,0x0A,0x15,0x3A,0x00,0x00,0x55,0x00,0x55,0x80,0x55,0x22,0x55,0xAA,0x55,0xFF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0x22,0x55,0x80,0x55,0xAA,
0x55,0xA8,0x55,0xA2,0x55,0xAA,0x55,0xAA,0x55,0xEA,0x55,0xBB,0x55,0x00,0x00,0x2B,0x55,0xEE,0x55,0x3A,0x55,0x2A,0x15,0x02,0x05,0x02,0x00,0x00,0x00,0x00,0x15,0x2A,0x35,0x0E,0x35,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x2A,0x14,0x28,0x10,0x20,0x00,0x00,0x01,0x02,0x05,0x0A,0x15,0x3A,0x55,0xEA,0x55,0xBB,0x00,0x00,0x00,0xBB,0x55,0xEA,0x55,0xAA,0x55,0xAA,0x55,0xA2,0x55,0xAA,0x55,0xAA,
0x05,0x02,0x05,0x02,0x05,0x02,0x05,0x03,0x05,0x07,0x05,0x03,0x05,0x00,0x00,0x00,0x01,0x02,0x01,0x00,0x00,0x00,0x50,0x38,0x54,0x6A,0x54,0x7A,0x55,0x6A,0x55,0x2A,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x2A,0x55,0x6A,0x55,0x3A,0x55,0x6A,0x14,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x00,0x00,0x00,0x0B,0x05,0x0F,0x05,0x0B,0x05,0x0E,0x05,0x0A,0x05,0x0A,0x05,0x0A,
0x54,0xEE,0x54,0xFA,0x54,0xFE,0x14,0x0A,0x00,0x00,0x00,0x80,0x40,0xA0,0x50,0xB8,0x54,0xAC,0x54,0xB8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x50,0xAC,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xB0,0x54,0xA8,0x54,0xB8,0x54,0xA8,0x54,0xB8,0x54,0xF8,0x50,0xA0,0x40,0x80,0x00,0x00,0x50,0xA8,0x70,0xF8,0xD0,0xF8,0x54,0xB8,0x54,0xE8,0x54,0xB8

};

flash char buttom[]={

//next
0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xFE,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80,
0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x01,

0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x02,0x04,0x08,0x10,0x20,0x40,0x80,
0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x40,0x20,0x10,0x08,0x04,0x02,0x01,

//Perv
0x80,0xC0,0xE0,0xF0,0xF8,0xFC,0xFE,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
0x01,0x03,0x07,0x0F,0x1F,0x3F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,

0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0xF0,
0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0F

} ;

#define NEXT    0
#define NEXT1   1
#define PERV    2
#define PERV1   3


void show_pic(flash char *pic,char x, char y,char SPEED){

char  i,j,XS,YS;

       XS=*pic;
       YS=*(pic+1);
    for(j=0;j<YS;j++){
        ks0108_gotoxy(0+x,j+y);;
    for(i=0;i<XS;i++)
        {
        ks0108_Write(pic[j*XS+i+2]);
            }
            delay_ms(SPEED);
  }

}

void echange_right(flash char *pic,flash char *newpic, char x,char y){

char  i,j,XS,YS,c;

       XS=*pic;
       YS=*(pic+1);

    for(c=0;c<XS+1;c+=10){

        for(i=0;i<XS-c;i++){
            for(j=0;j<YS;j++)
            {
            ks0108_gotoxy(x+i+c,j+y);
            ks0108_Write(pic[j*XS+(i)+2]);
            }

        }

        for(i=0;i<c;i++){
            for(j=0;j<YS;j++)
            {
            ks0108_gotoxy(x+i,j+y);;
            ks0108_Write(newpic[j*XS+ (XS-c)+i +2]);
           //ks0108_Write(0);
            }

        }

    }
}


void echange_left(flash char *pic,flash char *newpic, char x,char y){

char  i,j,XS,YS,c;

       XS=*pic;
       YS=*(pic+1);

    for(c=0;c<XS+1;c+=10){
        for(i=c;i<XS;i++){
            for(j=0;j<YS;j++)
            {
            ks0108_gotoxy((i-c)+x,j+y);
            ks0108_Write(pic[j*XS+i+2]);
            }

        }

        for(i=0;i<c;i++){
            for(j=0;j<YS;j++)
            {
            ks0108_gotoxy(XS-(c-i)+x,j+y);
            ks0108_Write(newpic[j*XS+i+2]);
            }

        }

    }
}


void show_but(char x,char y,char type){
char i;

ks0108_gotoxy(x,y);
for(i=0;i<16;i++)
    ks0108_Write(buttom[type*32+i]);

ks0108_gotoxy(x,y+1);
for(i=0;i<16;i++)
    ks0108_Write(buttom[type*32+16+i]);
 delay_ms(50);
}
#include "GFX/sound.h"
#include "GFX/wave.h"
#include "GFX/font.h"
#include "GFX/GFX.c"
//
void put_char(char x,char y,char ch){
char i;

ks0108_gotoxy(x,y);
for(i=0;i<5;i++)
     ks0108_Write(font[(ch-' ')*5+i]);

}


void lputs(char x,char y, char *st){
char i=0;

while(*st!=0){
    put_char(x+i*6,y,*st);
    i++;
    st++;
    }
}

void lputsf(char x,char y,flash char *st){

char i=0;

while(*st!=0){
    put_char(x+i*6,y,*st);
    i++;
    st++;
    }

}


#include "key.c"
// KEY
//Debounce definitions
#define KEY_DDR     DDRD
#define KEY_PIN     PIND
#define KEY_PORT     PORTD

#define BTN_UP      4
#define BTN_DN      3
#define BTN_LT      2
#define BTN_RT      5
#define BTN_EN      6
#define BTN_MD      0
#define BTN_ES      1

#define KEY_MSK     (1<<BTN_UP | 1<<BTN_DN | 1<<BTN_LT | 1<<BTN_RT | 1<<BTN_EN | 1<<BTN_MD | 1<<BTN_ES)
volatile unsigned char key_press;
//Debounce
//unsigned char debounce_cnt = 0;
unsigned char key_state;

unsigned char get_key_press(unsigned char key_mask)
{
  #asm("cli")
  key_mask &= key_press;                        // read key(s)
  key_press ^= key_mask;                        // clear key(s)
  #asm("sei")
  return key_mask;
}

void Key_init(void){
KEY_DDR=~KEY_MSK;
KEY_PORT=KEY_MSK;

}
#include "timer.c"


// Timer 0 output compare interrupt service routine
interrupt [TIM0_COMP] void timer0_comp_isr(void)
{
      static unsigned char ct0, ct1;
  unsigned char i;
  i = key_state ^ ~KEY_PIN;    // key changed ?
  ct0 = ~( ct0 & i );          // reset or count ct0
  ct1 = ct0 ^ (ct1 & i);       // reset or count ct1
  i &= ct0 & ct1;              // count until roll over ?
  key_state ^= i;              // then toggle debounced state
  key_press |= key_state & i;  // 0->1: key press detect
    // Call Evry 10ms in 8MHZ CPU
 Play_Tune();
}


void init_timer0(){
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 7.813 kHz
// Mode: CTC top=OCR0
// OC0 output: Disconnected
TCCR0=0x0D;
TCNT0=0x00;
OCR0=0x4E;

TIMSK=0x02;


}
#include "game's/maze.c"
//
#define xy(x,y)   x+y*16
#define    UP   1
#define    DOWN   2
#define    RIGHT    4
#define    LEFT    8

struct MAZE_GMAE
{

 char p_x;
 char p_y;
 char s_x;
 char s_y;
 char e_x;
 char e_y;
 int move;
 char level;
 flash char *map;
}maze;

#define level_len   132
flash char maze_levels[660]={
0x02,0x01,
0x10,0x08,
0x0D,0x08,0x03,0x03,0x01,0x05,0x09,0x05,0x09,0x03,0x01,0x07,0x0B,0x01,0x03,0x05,
0x0A,0x04,0x09,0x01,0x02,0x04,0x0C,0x0A,0x04,0x09,0x02,0x03,0x05,0x0A,0x05,0x0C,
0x0D,0x0C,0x0C,0x0C,0x09,0x06,0x0A,0x05,0x0A,0x06,0x09,0x05,0x0C,0x09,0x06,0x0E,
0x0C,0x0A,0x02,0x06,0x0A,0x01,0x05,0x0A,0x03,0x05,0x0C,0x0A,0x02,0x06,0x09,0x05,
0x08,0x07,0x09,0x03,0x01,0x06,0x0A,0x03,0x05,0x0C,0x0C,0x09,0x03,0x05,0x0C,0x0C,
0x08,0x05,0x0A,0x03,0x02,0x03,0x05,0x09,0x06,0x0C,0x0A,0x02,0x05,0x0C,0x0C,0x0C,
0x08,0x04,0x09,0x03,0x05,0x09,0x04,0x0A,0x01,0x00,0x07,0x0D,0x0A,0x02,0x06,0x0C,
0x0E,0x0A,0x02,0x03,0x02,0x06,0x0A,0x07,0x0E,0x0A,0x03,0x06,0x0F,0x0B,0x07,0x0C,

0x08,0x01,
0x08,0x08,
0x0D,0x09,0x01,0x03,0x01,0x03,0x05,0x0A,0x03,0x05,0x0D,0x09,0x03,0x03,0x03,0x05,
0x0C,0x0A,0x02,0x05,0x0A,0x05,0x0A,0x01,0x07,0x0A,0x04,0x0A,0x03,0x05,0x09,0x06,
0x0C,0x09,0x01,0x00,0x03,0x06,0x09,0x06,0x09,0x03,0x02,0x01,0x03,0x04,0x08,0x07,
0x0A,0x04,0x0C,0x0A,0x01,0x05,0x08,0x05,0x0A,0x03,0x05,0x08,0x05,0x0C,0x0A,0x05,
0x09,0x06,0x0A,0x03,0x06,0x0A,0x06,0x08,0x03,0x07,0x0C,0x0E,0x0A,0x04,0x09,0x04,
0x0C,0x09,0x03,0x01,0x03,0x03,0x05,0x0A,0x05,0x09,0x04,0x09,0x03,0x06,0x0C,0x0C,
0x08,0x06,0x0D,0x0A,0x03,0x05,0x0A,0x05,0x0A,0x06,0x08,0x02,0x03,0x01,0x06,0x0C,
0x0E,0x0B,0x06,0x0F,0x0B,0x02,0x07,0x0C,0x0B,0x07,0x0A,0x03,0x03,0x02,0x07,0x0E,

0x01,0x02,
0x010,0x04,
0x09,0x05,0x09,0x03,0x01,0x05,0x09,0x05,0x0B,0x05,0x0D,0x09,0x05,0x0D,0x0D,0x0D,
0x06,0x0A,0x04,0x09,0x02,0x04,0x0C,0x0A,0x01,0x00,0x06,0x0C,0x0C,0x0C,0x0A,0x06,
0x09,0x05,0x0C,0x0A,0x01,0x06,0x08,0x05,0x0A,0x02,0x05,0x0C,0x0C,0x08,0x03,0x05,
0x08,0x04,0x0E,0x09,0x00,0x05,0x0C,0x0C,0x09,0x03,0x04,0x0C,0x0E,0x08,0x03,0x02,
0x0C,0x0C,0x09,0x06,0x0C,0x0A,0x04,0x0C,0x0A,0x05,0x0C,0x0C,0x0B,0x02,0x01,0x07,
0x08,0x06,0x08,0x07,0x0A,0x03,0x04,0x0C,0x09,0x06,0x0C,0x0C,0x09,0x05,0x08,0x05,
0x0C,0x09,0x02,0x01,0x05,0x09,0x06,0x0C,0x0C,0x09,0x06,0x0A,0x06,0x0E,0x0A,0x04,
0x0A,0x06,0x0B,0x06,0x0A,0x02,0x03,0x02,0x06,0x0A,0x03,0x03,0x03,0x03,0x03,0x06,

0x01,0x06,
0x010,0x04,
0x0D,0x09,0x07,0x09,0x03,0x03,0x03,0x03,0x03,0x05,0x0B,0x07,0x09,0x03,0x01,0x05,
0x0C,0x0A,0x05,0x08,0x05,0x09,0x03,0x05,0x09,0x00,0x03,0x07,0x08,0x03,0x06,0x0C,
0x0C,0x09,0x06,0x0C,0x08,0x06,0x09,0x06,0x08,0x06,0x09,0x01,0x06,0x0B,0x01,0x06,
0x0C,0x08,0x03,0x04,0x0C,0x0D,0x0A,0x03,0x06,0x09,0x06,0x0C,0x09,0x05,0x0A,0x01,
0x08,0x02,0x05,0x0A,0x02,0x04,0x09,0x07,0x09,0x02,0x05,0x0C,0x0C,0x0C,0x09,0x06,
0x06,0x09,0x04,0x09,0x01,0x02,0x06,0x0B,0x06,0x09,0x04,0x0C,0x0C,0x0A,0x02,0x07,
0x09,0x06,0x0A,0x06,0x0C,0x09,0x03,0x03,0x01,0x02,0x06,0x0A,0x02,0x01,0x03,0x07,
0x0A,0x03,0x03,0x03,0x02,0x02,0x03,0x07,0x0A,0x03,0x03,0x03,0x07,0x0A,0x03,0x07,

0x01,0x01,
0x010,0x06,
0x01,0x03,0x03,0x03,0x05,0x0D,0x09,0x05,0x09,0x05,0x09,0x05,0x09,0x01,0x05,0x0D,
0x0C,0x09,0x03,0x05,0x0C,0x0C,0x0C,0x0A,0x06,0x0C,0x0C,0x0A,0x04,0x0C,0x08,0x06,
0x0C,0x0C,0x09,0x06,0x08,0x04,0x0A,0x01,0x05,0x0A,0x06,0x09,0x06,0x0C,0x0E,0x0D,
0x0A,0x04,0x0A,0x03,0x06,0x08,0x01,0x06,0x0C,0x09,0x03,0x06,0x09,0x02,0x05,0x0C,
0x0D,0x0A,0x07,0x0B,0x05,0x0C,0x0A,0x05,0x0C,0x0C,0x09,0x03,0x06,0x09,0x02,0x06,
0x0C,0x09,0x03,0x03,0x02,0x06,0x09,0x04,0x0C,0x0C,0x08,0x05,0x09,0x06,0x09,0x01,
0x08,0x02,0x05,0x09,0x05,0x09,0x04,0x08,0x06,0x0C,0x0C,0x08,0x02,0x05,0x08,0x06,
0x0E,0x0F,0x0A,0x06,0x0A,0x06,0x0A,0x02,0x07,0x0A,0x06,0x0A,0x03,0x02,0x06,0x0F
 };


flash char sh[]={0x00,0x3C,0x42,0x5A,0x5A,0x42,0x3C,0x00};
flash char _maze[]=
{
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
};



void Clear_box(char x,char y){

 int i;
 char bg,BGM;

 bg=maze.map[xy(x,y)];
  ks0108_gotoxy(x*8,y);
  if (bg==0){
   for(i=0;i<8;i++)
    ks0108_Write(0);
  return ;
 }

 for(i=0;i<8;i++){
    BGM=_maze[(bg-1)*8+i];
    ks0108_Write(BGM);
    }
}

void Drow_maze_one(char x,char y,char maz){

 int i;
  ks0108_gotoxy(x*8,y);
 if (maz==0){
   for(i=0;i<8;i++)
    ks0108_Write(0);
  return ;
 }
 for(i=0;i<8;i++)
    ks0108_Write(_maze[(maz-1)*8+i]);

}

void Drow_maze(){
 char i,j;

  for(j=0;j<8;j++)
    for(i=0;i<16;i++)
        Drow_maze_one(i,j,maze.map[xy(i,j)]);
}


void Drow_box(char x,char y){

 int i;
 char bg,BGM;

 bg=maze.map[xy(x,y)];

 ks0108_gotoxy(x*8,y);
 for(i=0;i<8;i++){
    BGM=_maze[(bg-1)*8+i];
    ks0108_Write(sh[i]|BGM);
    }
}

void load_maze(char level){

  maze.p_x =maze_levels[level_len*level+0]-1;
  maze.p_y =maze_levels[level_len*level+1]-1;
  maze.s_x =maze_levels[level_len*level+0]-1;
  maze.s_y =maze_levels[level_len*level+1]-1;
  maze.e_x =maze_levels[level_len*level+2]-1;
  maze.e_y =maze_levels[level_len*level+3]-1;
  maze.map = maze_levels+level_len*level+4;
  maze.move =0;

  Drow_maze();
  Drow_box(maze.p_x ,maze.p_y );
}

void maze_init(){
maze.level=0 ;
load_maze(maze.level);

}

void move_right(void){
   char bg;
        if(maze.p_x == 15 )
            return;
        bg=maze.map[xy(maze.p_x ,maze.p_y )];
        if((bg&RIGHT)==0){
        Clear_box(maze.p_x++,maze.p_y );
        Drow_box(maze.p_x,maze.p_y);
        maze.move++;
        }

}

void move_left(void){

   char bg;
   if(maze.p_x == 0 )
            return;
        bg=maze.map[xy(maze.p_x,maze.p_y)];
        if((bg&LEFT)==0){
        Clear_box(maze.p_x--,maze.p_y);
        Drow_box(maze.p_x,maze.p_y);
        maze.move++;
        }

}

void move_down(void){
    char bg;
            if(maze.p_y == 7 )
            return;
        bg=maze.map[xy(maze.p_x,maze.p_y)];
        if((bg&DOWN)==0){
        Clear_box(maze.p_x,maze.p_y++);
        Drow_box(maze.p_x,maze.p_y);
        maze.move++;
        }

}


void move_up(void){

   char bg;
        if(maze.p_y ==0 )
            return;
        bg=maze.map[xy(maze.p_x,maze.p_y)];
        if((bg&UP)==0){
        Clear_box(maze.p_x,maze.p_y--);
        Drow_box(maze.p_x,maze.p_y);
        maze.move++;
        }

}

char maze_win(){

char temp[5];
ks0108_ClearScreen();

lputsf(20,0,"YOU WIN Level ");
put_char(100,0,'0'+maze.level);
lputsf(7,2,"For New Game Press");
lputsf(40,3,"<-ENTER->");
lputsf(5,4,"Or Esc To Exit Game.");

sprintf(temp,"%i",maze.move);
lputsf(10,6,"Total Movment is ");
lputs(60,7,temp);
maze.level++;
while(1){


       if (get_key_press(1<<BTN_EN)){
       paly_sound_key(key_sound);
       load_maze(maze.level);
       return 1;
       }

        if (get_key_press(1<<BTN_ES)){
       paly_sound_key(key_sound);
       return 0;
       }
}
}


void Run_maze(void){

ks0108_ClearScreen();
maze_init();
play_sound(maze_sound);

while (1)
      {
        if(maze.e_x == maze.p_x  && maze.e_y == maze.p_y){
        if(maze_win()==0)
            break;
        }

        if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
            else
                play_sound(maze_sound);

       if (get_key_press(1<<BTN_RT)){
       paly_sound_key(key_sound);
        move_right();
       }

       if (get_key_press(1<<BTN_LT)){
       paly_sound_key(key_sound);
        move_left();
       }

       if (get_key_press(1<<BTN_DN)){
        paly_sound_key(key_sound);
        move_down();
        }

       if (get_key_press(1<<BTN_UP)){
       paly_sound_key(key_sound);
        move_up();
        }

       if (get_key_press(1<<BTN_ES)){
       paly_sound_key(key_sound);
        break;
        }
      };

}
#include "game's/tetris.c"
//
#define BOX_board_bottom 21
#define BOX_board_right 11

#define array_size (((BOX_board_bottom+8)/8) * (BOX_board_right + 1))

#define default_fg_color 1
#define default_bg_color 0
#define GLCD_GoTo(x,y)   ks0108_gotoxy(x,y)
#define GLCD_WriteData(dat) ks0108_Write(dat)

#define white 0

unsigned char BOX_piece[4];

flash char  BOX_reference[7][4][4] = {
        //T
        {
                {
                        0b00000010,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000001,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000111,
                        0b00000000,
                        0b00000000
                }
        },

        // S
        {
                {
                        0b00000010,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000110,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000110,
                        0b00000000,
                        0b00000000
                }
        },

        // Z
        {
                {
                        0b00000001,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000110,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000001,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000110,
                        0b00000011,
                        0b00000000,
                        0b00000000
                }
        },

        // L
        {
                {
                        0b00000011,
                        0b00000001,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000001,
                        0b00000111,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000010,
                        0b00000011,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000100,
                        0b00000000
                }
        },

        // J
        {
                {
                        0b00000001,
                        0b00000001,
                        0b00000011,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000100,
                        0b00000111,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000010,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000001,
                        0b00000000
                }
        },

        // Box
        {
                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                }
        },

        // Line
        {
                {
                        0b00000010,
                        0b00000010,
                        0b00000010,
                        0b00000010
                },

                {
                        0b00000000,
                        0b00001111,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000010,
                        0b00000010,
                        0b00000010
                },

                {
                        0b00000000,
                        0b00001111,
                        0b00000000,
                        0b00000000
                }
        }
};

//Variables
unsigned char BOX_location[array_size];
unsigned char x_loc, y_loc;     //Bottom left index of each piece
unsigned char cur_piece = 0;	//Index for BOX_reference
unsigned char rotate = 0;		//Index for piece rotation
unsigned char score;		//Track the number of rows completed

/**********************************************
 * Functions that handle bits in BOX_location[]
 * BOX_loc_return_bit
 * BOX_loc_set_bit
 * BOX_loc_clear_bit
 ************************************************/

unsigned char BOX_loc_return_bit(unsigned char X, unsigned char Y)
{
  //Calculate array index and shift amount
  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
  unsigned char shift_index ;		//How much to shift for our bit mask

  shift_index = (Y)%8;		//How much to shift for our bit mask
  if (BOX_location[X+array_index_offset] & 1<<shift_index) return 1;
  else return 0;
}


void BOX_draw(unsigned char X, unsigned char Y, unsigned char color)
{
      unsigned char temp_data;
      unsigned char i;
	  if (X%2)
	  {
		  if (BOX_loc_return_bit(X-1,Y))
		        temp_data = 0xFF;
		  else
		        temp_data = 100;
	  }
	  else
	  {
		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 0xFF;
		  else temp_data = 0x0F;
	  }
}
#include "menu.c"
//menu
#define MENU_ITEM   2
flash char *menu_pic[]={maze_logo,tetris_logo};
char ci=0;

void start_menu(){

char i;
flash char *curnet_pic=menu_pic[ci];
ks0108_ClearScreen();
for(i=1;i<8;i++){
ks0108_gotoxy(23,i);
ks0108_Write(255);
ks0108_gotoxy(104,i);
ks0108_Write(255);
}
show_but(2,4,PERV);
show_but(108,4,NEXT);
show_pic(curnet_pic,24,1,0);
play_sound(start);
}

void Show_game_menu(){



start_menu();

while(1){

       if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
            else
                play_sound(start);

       if (get_key_press(1<<BTN_RT)){  // next Item
            if(ci<MENU_ITEM-1){
                show_but(108,4,NEXT1);
                paly_sound_key(key_sound);
                show_but(108,4,NEXT);
                echange_left(menu_pic[ci++],menu_pic[ci], 24,1);

                }
        }

       if (get_key_press(1<<BTN_LT)){// Prev item
            if(ci>0){
                show_but(2,4,PERV1);
                paly_sound_key(key_sound);
                show_but(2,4,PERV);
                echange_right(menu_pic[ci--],menu_pic[ci], 24,1);
            }
        }

        if (get_key_press(1<<BTN_EN)){
           paly_sound_key(key_sound);
           switch(ci){

           case 0: Run_maze(); break;


           }
           start_menu();
        }

}

}









void main(void)
{


ks0108_Init();
ks0108_ClearScreen();
sound_init();
Key_init();
init_timer0();
#asm("sei");
play_sound(start);
show_pic(agape_logo,0,0,50);

// while(1);
while (1)
      {
  //     if (get_key_press(1<<BTN_MD))
    //        if(sound_is_play)
      //          stop_sound();
        //    else
          //      play_sound(start);

       //if (get_key_press(1<<BTN_EN))
          //  Show_game_menu();
         //
      };
}
